#include "humans.pov"


// Here is all stuff that is not used in main file
#ifndef (TheCity)
  light_source { <10,15,-15> color rgb 1 shadowless}
  camera { location <2.125,10.5,-4> look_at <2.75,0,7> angle 50 }
#end

#declare clouds =
texture {
  pigment { 
    bozo 
    colour_map {
      [0   color rgb 0.4]
      [.7 colour rgb <.35,.35,.3>]
    }
    turbulence 1 
    scale 15000
  }
  finish { ambient .6 }
}  

#declare waters = 
  texture { 
    pigment { 
      color rgb <.3,.3,.3> 
    }
    normal { 
      bumps .02 scale .175 
    }
    finish { 
      reflection 1/3 
    }
  }

#declare street = 
  texture { 
    pigment { 
      checker 
      pigment { color rgb <.4,.35,.3> } 
      pigment { color rgb <.5,.45,.4> } 
      scale 0.00025 
      turbulence .4
    } 
  }
  texture {
    pigment {
      bozo
      colour_map {
        [0 color rgbt <0,0,0,1>]
        [0.5 color rgbt <.5,0,0,.9>]
        [0.9 color rgbt <0,0,0,.75>]
      }
      scale .01
      turbulence .5
    }
  }

#declare bushes = 
  texture { pigment { color rgb <.7,1,.7> } }
#declare ground = texture {
    spherical
    scale 460
    texture_map {
      [0 bushes]
      [0.5 bushes]
      [0.5 street]
      [1 street]
    }
}

union{
  difference {
    plane { y 0 texture { ground } }
    plane { x+.7*z 40 texture { ground } }
  }
  difference {
    plane { y 0 texture { ground } }
    plane { -x-.7*z, -20 texture { ground } }
  }
  plane { y, -.4  texture { waters } }
}

plane { -y, -6000 texture { clouds } }

// On the other side 
object { boat3 rotate y*145 translate <21,-.4,38> }
object { boat3 scale 1.15 rotate y*145 translate <22,-.4,36> }
object { boat3 rotate y*145 translate <23,-.4,35> }

object { human1 rotate y*145 translate <22,0,39> }
object { human1 rotate y*145 translate <23,0,38> }
object { human1 rotate y*45 translate <23.1,0,37.75> }
object { human1 rotate y*145 translate <23.5,0,37> }
object { human1 rotate y*55 translate <23.75,0,37> }
object { human1 rotate y*55 translate <23.95,0,37> }

// Sailing
object { boat2 translate <19,-.4,33> }
object { boat2 rotate y*-105 translate <0,-.4,45> }

// This side
object { boat3 scale 1.1 rotate y*-35 translate <9,-.4,25> }
object { boat1 rotate y*-35 translate <8.125,-.4,26> }
object { boat2 scale .9 rotate y*-35 translate <7.25,-.4,27> }
object { boat1 scale 1.1 rotate y*-35 translate <6.5,-.4,29> }

// This side, lower group
object { boat3 scale 1.05 rotate <5,-35,0> translate <10,-.4,23.25> }
object { boat3 scale 1.05 rotate <5,-35,0> translate <12,-.4,21> }
object { boat3 scale 1.0 rotate <0,-40,0> translate <12.8,-.4,20> }
object { boat1 scale 1.05 rotate <0,-35,0> translate <14,-.4,18.2> }

object { human3 rotate <0,-40,0> translate <9.5,0,21> }
object { human6 rotate <0,50,0> translate <9.7,0,20.8> }

object { human3 rotate <0,-40,0> translate <10,0,20> }
object { human5 rotate <0,40,0> translate <10.2,0,19.8> }

object { human5 rotate <0,40,0> translate <11,0,19> }

object { human1 rotate <0,40,0> translate <12,0,17> }

// Templeside boats
object { boat3 rotate y*140 translate <-8,-.4,79> }
object { boat1 rotate y*140 translate <-7,-.4,78> }
object { boat3 rotate y*140 translate <-6,-.4,77> }

object { boat2 rotate y*140 translate <-2.5,-.4,69.5> }
  object {human3 translate <-7,0,80> }
  object {human5 translate <-7.5,0,82> }
  object {human3 translate <-5,0,77.5> }
  object {human6 translate <-4.5,0,76.5> }
  object {human1 translate <-4.7,0,76.5> }
  object {human5 translate <-4,0,76> }
  object {human4 translate <-3.5,0,75.5> }
  object {human6 translate <-3,0,75> }

  object {human3 translate <0,0,69.5> }
  object {human4 translate <.5,0,69> }
  object {human6 translate <1,0,68.5> }
  object {human5 translate <1.6,0,68> }
  object {human6 translate <1.6,0,68.2> }
  object {human5 translate <2,0,67.5> }
object { boat3 rotate y*150 translate <-1,-.4,68> }
object { boat1 rotate y*145 translate <0,-.4,67> }

object { boat1 rotate y*145 translate <2,-.4,64> }
object { boat3 scale .96 rotate y*145 translate <3,-.4,63> }

object { boat2 scale 1.1 rotate y*100 translate <-4,-.4,62> }

